#pragma once

#include "selectors.h"

#include <solomon/services/dataproxy/lib/datasource/datasource.h>
#include <solomon/libs/cpp/actors/runtime/actor_runtime.h>
#include <solomon/libs/cpp/yasm/shard_config/shard_config.h>

namespace NSolomon::NDataProxy {

struct TYasmConfig {
    std::shared_ptr<const THashMap<TString, TVector<TString>>> MetagroupToGroups;
    NYasm::IShardConfigPtr ShardConfig;
};

std::unique_ptr<NActors::IActor> YasmDataSourceActor(
        TYasmConfig yasmConfig,
        IDataSourcePtr baseDataSource,
        NMonitoring::TMetricRegistry& registry);

} // namespace NSolomon::NDataProxy
