#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/datasource/result_handler.h>
#include <solomon/services/dataproxy/lib/event_slots.h>

#include <solomon/libs/cpp/actors/events/events.h>

#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/actors/core/actorsystem.h>

namespace NSolomon::NDataProxy {

class TYasmDataSourceEvents: private TEventSlot<EEventSpace::DataProxy, ES_DATA_SOURCE_YASM> {
    enum {
        Find = SpaceBegin,
        ResolveOne,
        ResolveMany,
        MetricNames,
        LabelKeys,
        LabelValues,
        UniqueLabels,
        ReadOne,
        ReadMany,
        Error,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

    template <typename TQueryType>
    static constexpr auto EventType() noexcept {
        if constexpr (std::is_same_v<TQueryType, TFindQuery>) return Find;
        else if constexpr (std::is_same_v<TQueryType, TResolveOneQuery>) return ResolveOne;
        else if constexpr (std::is_same_v<TQueryType, TResolveManyQuery>) return ResolveMany;
        else if constexpr (std::is_same_v<TQueryType, TMetricNamesQuery>) return MetricNames;
        else if constexpr (std::is_same_v<TQueryType, TLabelKeysQuery>) return LabelKeys;
        else if constexpr (std::is_same_v<TQueryType, TLabelValuesQuery>) return LabelValues;
        else if constexpr (std::is_same_v<TQueryType, TUniqueLabelsQuery>) return UniqueLabels;
        else if constexpr (std::is_same_v<TQueryType, TReadOneQuery>) return ReadOne;
        else if constexpr (std::is_same_v<TQueryType, TReadManyQuery>) return ReadMany;
        else static_assert(TDependentFalse<TQueryType>, "unsupported type");
    }

public:
    template <typename TQueryType, typename THandlerType>
    struct TRequest: public NActors::TEventLocal<TRequest<TQueryType, THandlerType>, EventType<TQueryType>()> {
        TRequest(TQueryType query, IResultHandlerPtr<THandlerType> handler) noexcept
            : Query{std::move(query)}
            , Handler{std::move(handler)}
        {
        }
        TQueryType Query;
        IResultHandlerPtr<THandlerType> Handler;
    };

    using TReadManyRequest = TRequest<TReadManyQuery, TReadManyResult>;
    using TFindRequest = TRequest<TFindQuery, TFindResult>;
    using TMetricNamesRequest = TRequest<TMetricNamesQuery, TMetricNamesResult>;
    using TLabelKeysRequest = TRequest<TLabelKeysQuery, TLabelKeysResult>;
    using TLabelValuesRequest = TRequest<TLabelValuesQuery, TLabelValuesResult>;
    using TUniqueLabelsRequest = TRequest<TUniqueLabelsQuery, TUniqueLabelsResult>;
};

} // namespace NSolomon::NDataProxy
