#pragma once

#include <util/generic/strbuf.h>
#include <solomon/libs/cpp/yasm/constants/project.h>

namespace NSolomon::NDataProxy {

constexpr TStringBuf SERVICE_VALUE = "yasm";
constexpr TStringBuf ALL_GROUPS = "group_*";
constexpr TStringBuf ALL_HOSTS = "host_*";

/**
 * Returns itype for projects with yasm_ prefix. Returns an empty string otherwise
 */
inline TStringBuf ExtractItype(TStringBuf project) {
    TStringBuf itype;

    project.AfterPrefix(NYasm::YASM_PROJECT_PREFIX_STS1, itype) || 
    project.AfterPrefix(NYasm::YASM_PROJECT_PREFIX_STS2, itype) ||
    project.AfterPrefix("yasm_", itype);

    return itype;
}

} // namespace NSolomon::NDataProxy
