#pragma once

#include <solomon/services/dataproxy/lib/datasource/datasource.h>

#include <solomon/libs/cpp/actors/fwd.h>

#include <infra/yasm/common/groups/metagroup_groups.h>

#include <util/generic/ptr.h>
#include <util/generic/yexception.h>

namespace NSolomon::NDataProxy {

/**
 * An actor which doesn't itself aggregate data. Instead, it requests metrics metadata from dataSource,
 * and filters them by leaving the most aggregated part. E.g. found metrics
 * {
 *   {signal=name, ctype=prod, geo=sas},
 *   {signal=name, ctype=prod, geo=vla},
 *   {signal=name, ctype=prod, geo=/SELF}
 * }
 * will result in {{signal=name, ctype=prod, geo=/SELF}}.
 * After that, it constructs a ReadMany query and requests metrics data from dataSource
 *
 * @param originalQuery original ReadMany handler
 * @param handler handler that will be called on result and error only after the construction
 * @param dataSource data source used to find metrics to aggregate
 * @throws TInvalidReadManyQuery if original query is invalid
 */
std::unique_ptr<NActors::IActor> YasmMetricsAggregator(
    TReadManyQuery originalQuery,
    IResultHandlerPtr<TReadManyResult> handler,
    IDataSourcePtr dataSource,
    NMonitoring::TMetricRegistry& registry,
    NTracing::TSpanId traceCtx = {});

} // namespace NSolomon::NDataProxy
