#include "selectors.h"

// TODO: move from Fetcher to solomon/libs/cpp/yasm/shard_key
#include <solomon/services/fetcher/lib/yasm/shard_key.h>

#include <solomon/libs/cpp/yasm/constants/labels.h>
#include <solomon/libs/cpp/yasm/constants/project.h>

#include <util/string/join.h>

namespace NSolomon::NDataProxy {

TYasmSelectorsTransformer::TYasmSelectorsTransformer(NYasm::IShardConfigPtr shardConfig)
    : ShardConfig_{std::move(shardConfig)}
{
}

void TYasmSelectorsTransformer::FillHostOrGroup(TSelectors& selectors, const THostsLabel& hosts) const {
    switch (hosts.Type) {
        case THostsLabel::EType::HOST:
            selectors.Override(NLabels::LABEL_HOST, hosts.Value);
            break;
        case THostsLabel::EType::GROUP:
            selectors.Override(NLabels::LABEL_GROUP, hosts.Value);
            break;
        case THostsLabel::EType::METAGROUP:
            ythrow yexception() << "Unresolved metagroup:" << hosts.Value;
            break;
        case THostsLabel::EType::UNKNOWN:
            ythrow yexception() << "\"hosts\" label is empty";
            break;
    }
}

void TYasmSelectorsTransformer::FillClusterService(TSelectors& selectors, TStringBuf itype, const THostsLabel& hosts) const {
    Y_ENSURE(itype);
    selectors.Add(NLabels::LABEL_SERVICE, SERVICE_VALUE);

    // computing label 'cluster'
    if (auto signalIt = selectors.Find(NYasm::LABEL_SIGNAL); signalIt != selectors.end() && signalIt->IsExact()) {
        if (hosts.Type == THostsLabel::EType::METAGROUP)  {
            ythrow yexception() << "Unresolved metagroup: " << hosts.Value;
        } else if (hosts.Type == THostsLabel::EType::UNKNOWN) {
            ythrow yexception() << "\"hosts\" label is empty";
        }

        auto shardsCnt = ShardConfig_->GetShardCount(itype);

        // TODO(ivanzhukov): write a separate code to compute 'cluster' without re-checking if a hosts value is a group or not
        NSolomon::NFetcher::NYasm::TYasmShardKey sk(itype, hosts.Value, signalIt->Pattern(), shardsCnt);
        selectors.Override(NLabels::LABEL_CLUSTER, sk.GetCluster());
    } else {
        switch (hosts.Type) {
            case THostsLabel::EType::HOST:
                selectors.Override(NLabels::LABEL_CLUSTER, ALL_HOSTS);
                break;
            case THostsLabel::EType::GROUP:
                selectors.Override(NLabels::LABEL_CLUSTER, ALL_GROUPS);
                break;
            case THostsLabel::EType::METAGROUP:
                ythrow yexception() << "Unresolved metagroup: " << hosts.Value;
                break;
            case THostsLabel::EType::UNKNOWN:
                ythrow yexception() << "\"hosts\" label is empty";
                break;
        }
    }

    selectors.Remove(NLabels::LABEL_HOSTS);
}

} // namespace NSolomon::NDataProxy
