#pragma once

#include "labels.h"

#include <solomon/libs/cpp/actors/runtime/actor_runtime.h>
#include <solomon/libs/cpp/labels/known_keys.h>
#include <solomon/libs/cpp/selectors/selectors.h>
#include <solomon/libs/cpp/yasm/group/group.h>
#include <solomon/libs/cpp/yasm/shard_config/shard_config.h>

#include <util/generic/hash.h>
#include <util/generic/strbuf.h>

namespace NSolomon::NDataProxy {

struct THostsLabel {
    enum class EType {
        UNKNOWN,
        HOST,
        GROUP,
        METAGROUP
    };

    TString Value;
    EType Type;

    THostsLabel(TString value, EType type) noexcept
        : Value{std::move(value)}
        , Type{type}
    {
    }

    template <typename F>
    static THostsLabel FromSelectors(const TSelectors& selectors, F&& isMetagroup) {
        if (auto hostsIt = selectors.Find(NLabels::LABEL_HOSTS); hostsIt != selectors.end()) {
            auto hosts = hostsIt->Pattern();
            auto isHostsExact = hostsIt->IsExact();
            auto type = EType::HOST;
            bool isGroup = isHostsExact && NYasm::IsGroupOrMetagroup(hosts);
            if (isGroup) {
                type = isMetagroup(hosts) ? EType::METAGROUP : EType::GROUP;
            }
            return THostsLabel{TString{hosts}, type};
        }
        return THostsLabel{"", EType::UNKNOWN};
    }
};

class TYasmSelectorsTransformer {
public:
    explicit TYasmSelectorsTransformer(NYasm::IShardConfigPtr shardConfig);
    void FillHostOrGroup(TSelectors& selectors, const THostsLabel& hosts) const;
    void FillClusterService(TSelectors& selectors, TStringBuf itype, const THostsLabel& hosts) const;

private:
    NYasm::IShardConfigPtr ShardConfig_;
};

} // namespace NSolomon::NDataProxy
