#pragma once

#include <solomon/libs/cpp/stockpile_codec/metric_archive.h>
#include <solomon/libs/cpp/ts_codec/bit_buffer.h>
#include <solomon/libs/cpp/ts_codec/points.h>

#include <infra/yasm/common/points/accumulators/accumulators.h>
#include <infra/yasm/common/points/hgram/hgram.h>
#include <infra/yasm/common/points/value/types.h>

#include <library/cpp/monlib/metrics/metric_type.h>

namespace NSolomon::NDataProxy {

class TValueToLogHistPoint: public NZoom::NValue::IUpdatable, public NZoom::NHgram::IHgramStorageCallback {
public:
    TValueToLogHistPoint(TInstant timestamp, TDuration step)
    {
        Point_.Time = timestamp;
        Point_.Step = step;
    }

    void MulNone() override final {
    }

    void MulFloat(const double) override final {
        ythrow yexception() << "not implemented";
    }

    void MulVec(const TVector<double>&) override final {
    }

    void MulCountedSum(const double, const ui64) override final {
        ythrow yexception() << "not implemented";
    }

    void MulHgram(const NZoom::NHgram::THgram& value) override final {
        value.Store(*this);
    }

    void OnStoreSmall(const TVector<double>& values, const size_t zeros) override final;
    void OnStoreNormal(const TVector<double>& values, const size_t zeros, const i16 startPower) override final;
    void OnStoreUgram(const NZoom::NHgram::TUgramBuckets& buckets) override final;

    NTs::TLogHistogramPoint GetPoint() const noexcept {
        return Point_;
    }

private:
    NTs::TLogHistogramPoint Point_;
};

class TValueToHistPoint: public NZoom::NValue::IUpdatable, public TValueToLogHistPoint::IHgramStorageCallback {
public:
    TValueToHistPoint(TInstant timestamp, TDuration step)
    {
        Point_.Time = timestamp;
        Point_.Step = step;
    }

    void MulNone() override final {
    }

    void MulFloat(const double) override final {
        ythrow yexception() << "not implemented";
    }

    void MulVec(const TVector<double>&) override final {
    }

    void MulCountedSum(const double, const ui64) override final {
        ythrow yexception() << "not implemented";
    }

    void MulHgram(const NZoom::NHgram::THgram& value) override final {
        value.Store(*this);
    }

    void OnStoreSmall(const TVector<double>& values, const size_t zeros) override final;
    void OnStoreNormal(const TVector<double>& values, const size_t zeros, const i16 startPower) override final;
    void OnStoreUgram(const NZoom::NHgram::TUgramBuckets& buckets) override final;

    NTs::THistogramPoint GetPoint() const noexcept {
        return Point_;
    }

private:
    NTs::THistogramPoint Point_;
};

class TValueToSummaryPoint: public NZoom::NValue::IUpdatable {
public:
    TValueToSummaryPoint(TInstant timestamp, TDuration step) {
        Point_.Time = timestamp;
        Point_.Step = step;
    }

    void MulNone() override final {
    }

    void MulFloat(const double value) override final;

    void MulVec(const TVector<double>&) override final {
    }

    void MulCountedSum(const double sum, const ui64 count) override final;

    void MulHgram(const NZoom::NHgram::THgram&) override final {
        ythrow yexception() << "not implemented";
    }

    NTs::TSummaryDoublePoint GetPoint() const noexcept {
        return Point_;
    }

private:
    NTs::TSummaryDoublePoint Point_;
};

class TValueToGaugePoint: public NZoom::NValue::IUpdatable {
public:
    TValueToGaugePoint(TInstant timestamp, TDuration step) {
        Point_.Time = timestamp;
        Point_.Step = step;
        Point_.Num = std::numeric_limits<double>::quiet_NaN();
    }

    void MulNone() override final {
    }

    void MulFloat(const double value) override final {
        Point_.Num = value;
        Point_.Denom = 0;
    }

    void MulVec(const TVector<double>&) override final {
    }

    void MulCountedSum(const double, const ui64) override final {
        ythrow yexception() << "trying to mul gauge with counted sum";
    }

    void MulHgram(const NZoom::NHgram::THgram&) override final {
        ythrow yexception() << "not implemented";
    }

    NTs::TDoublePoint GetPoint() const noexcept {
        return Point_;
    }

private:
    NTs::TDoublePoint Point_;
};

class TMetricSerializer {
public:
    explicit TMetricSerializer(NMonitoring::EMetricType type,
                               const NZoom::NAccumulators::TCompactAccumulatorsArray& accumulators,
                               TInstant startTime,
                               TDuration step)
        : Type_(type)
        , Accumulators_(accumulators)
        , StartTime_(startTime)
        , Step_(step)
    {}

    NTs::TBitBuffer Serialize();

private:
    const NMonitoring::EMetricType Type_;
    const NZoom::NAccumulators::TCompactAccumulatorsArray& Accumulators_;
    const TInstant StartTime_;
    const TDuration Step_;
};

class TValueTypeDetector {
public:
    TValueTypeDetector()
        : ValueType_(NZoom::NValue::EValueType::NONE)
    {}

    void OnValue(NZoom::NValue::TValueRef value);
    NMonitoring::EMetricType GetType() const noexcept;

private:
    NZoom::NValue::EValueType ValueType_;
};

size_t BucketsSizeAfterSerializing(const NZoom::NHgram::TUgramBuckets &buckets);

} // namespace NSolomon::NDataProxy
