#include <solomon/services/dataproxy/lib/datasource/yasm/cluster_name.h>
#include <solomon/services/fetcher/lib/yasm/shard_key.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NSolomon::NDataProxy;
using namespace NSolomon::NFetcher::NYasm;

TEST(TClusterNameTest, Host) {
    TStringBuf itype{"base"};
    TStringBuf host{"fghhvtkdxm6peft.man.yp-c.yandex.net"};
    TStringBuf signal{"cpu-id_hgram"};
    ui64 shardCount = 64;

    TYasmShardKey key{itype, host, signal, shardCount};
    EXPECT_EQ(key.GetCluster(), GetClusterName(host, signal, shardCount));
}

TEST(TClusterNameTest, Group) {
    TStringBuf itype{"base"};
    TStringBuf signal{"cpu-id_hgram"};
    ui64 shardCount = 64;

    TYasmShardKey key{itype, "ASEARCH", signal, shardCount};
    EXPECT_EQ(key.GetCluster(), GetClusterName("", signal, shardCount));
}
