#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>

namespace NSolomon::NDataProxy {

class TInvalidReadManyQuery: public yexception {
};

#define DP_ENSURE(CONDITION, MESSAGE)                 \
    do {                                              \
        if (Y_UNLIKELY(!(CONDITION))) {               \
            throw TInvalidReadManyQuery() << MESSAGE; \
        }                                             \
    } while (false)

TTimeRange ExtractAndRoundTimeRange(const TReadManyQuery& query, TDuration resolution);

void FillBaseQueryFields(const TQuery& source, TQuery& target);

TDuration ExtractAndAdjustResolution(TReadManyQuery& query);

} // namespace NSolomon::NDataProxy
