#pragma once

#include "labels.h"

#include <solomon/services/dataproxy/lib/datasource/result_handler.h>
#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/libs/cpp/labels/known_keys.h>
#include <solomon/libs/cpp/yasm/constants/labels.h>

#include <util/generic/algorithm.h>

namespace NSolomon::NDataProxy {

void TransformResult(TLabelKeysResult* res) {
    auto group = res->Strings.Put(NLabels::LABEL_GROUP);
    auto host = res->Strings.Put(NLabels::LABEL_HOST);
    auto& keys = res->Keys;

    EraseIf(keys, [=](ui32 key) {
            return key == host ||
                   key == group;
            });
}

void TransformResult(TLabelValuesResult* res) {
    auto self = res->Strings.Put(NYasm::AGGREGATED_MARKER);
    auto host = res->Strings.Put(NLabels::LABEL_HOST);
    auto group = res->Strings.Put(NLabels::LABEL_GROUP);
    auto cluster = res->Strings.Put(NLabels::LABEL_CLUSTER);
    auto service = res->Strings.Put(NLabels::LABEL_SERVICE);

    EraseIf(res->Labels,
            [=](const auto& label) {
                return label.Key == host || label.Key == group || label.Key == cluster || label.Key == service;
            });
    
    for (auto& label: res->Labels) {
        EraseIf(label.Values,
                [self](const auto& value) {
                    return value == self;
                });
    }
}

template <typename T>
class TYasmHandler: public IResultHandler<T> {
public:
    explicit TYasmHandler(IResultHandlerPtr<T> handler)
        : OriginalHandler_{std::move(handler)}
    {
    }

private:
    void OnSuccess(std::unique_ptr<T> res) override {
        TransformResult(res.get());
        OriginalHandler_->OnSuccess(std::move(res));
    }
    void OnError(TString&& project, EDataSourceStatus status, TString&& message) override {
        OriginalHandler_->OnError(std::move(project), status, std::move(message));
    }

private:
    IResultHandlerPtr<T> OriginalHandler_;
};

template <typename T>
IResultHandlerPtr<T> YasmHandler(IResultHandlerPtr<T>&& originalHandler) {
    return MakeIntrusive<TYasmHandler<T>>(originalHandler);
}

} // namespace NSolomon::NDataProxy
