#include "dataproxy_request_hash.h"

#include <solomon/libs/cpp/string_pool/string_pool.h>

namespace NSolomon::NDataProxy {

using namespace yandex::monitoring::dataproxy;

TString Hash(const yandex::monitoring::dataproxy::FindRequest& req) {
    THasher hasher;
    hasher.Update(req.selectors());
    hasher.Update(req.limit());
    return hasher.Finish();
}

TString Hash(const yandex::monitoring::dataproxy::LabelKeysRequest& req) {
    THasher hasher;
    hasher.Update(req.selectors());
    return hasher.Finish();
}

TString Hash(const yandex::monitoring::dataproxy::LabelValuesRequest& req) {
    THasher hasher;
    hasher.Update(req.selectors());
    hasher.Update(std::begin(req.keys()), std::end(req.keys()));
    hasher.Update(req.text_filter());
    hasher.Update(req.limit());
    return hasher.Finish();
}

TString Hash(const yandex::monitoring::dataproxy::MetricNamesRequest& req) {
    THasher hasher;
    hasher.Update(req.selectors());
    hasher.Update(req.text_filter());
    hasher.Update(req.limit());
    return hasher.Finish();
}

TString Hash(const ReadManyRequest& req) {
    THasher hasher;
    switch (req.query_case()) {
        case ReadManyRequest::QueryCase::kLookup:
            hasher.Update(req.lookup().selectors());
            hasher.Update(req.lookup().limit());
            break;

        case ReadManyRequest::QueryCase::kResolvedKeys: {
            NStringPool::TStringPool strings(req.resolved_keys().string_pool());
            for (ui32 id: req.resolved_keys().common_labels_idx()) {
                hasher.Update(strings[id]);
            }
            for (const auto& metric: req.resolved_keys().metric_keys()) {
                hasher.Update(strings[metric.name_idx()]);
                for (ui32 labelId: metric.labels_idx()) {
                    hasher.Update(strings[labelId]);
                }
            }
            break;
        }

        case ReadManyRequest::QueryCase::QUERY_NOT_SET:
            break;
    }

    hasher.Update(req.max_time_series_format());
    hasher.Update(req.from_millis());
    hasher.Update(req.to_millis());

    for (auto& operation: req.operations()) {
        hasher.Update(operation.SerializeAsStringOrThrow());
    }
    return hasher.Finish();
}

TString Hash(const ReadOneRequest& req) {
    THasher hasher;
    hasher.Update(req.name());
    hasher.Update(std::begin(req.labels()), std::end(req.labels()));
    hasher.Update(req.max_time_series_format());
    hasher.Update(req.from_millis());
    hasher.Update(req.to_millis());

    for (auto& operation: req.operations()) {
        hasher.Update(operation.SerializeAsStringOrThrow());
    }

    hasher.Update(req.force_replica_read());
    return hasher.Finish();
}

TString Hash(const ResolveManyRequest& req) {
    THasher hasher;

    // TODO: avoid twice pool decompression
    NStringPool::TStringPool strings(req.string_pool());
    for (ui32 id: req.common_labels_idx()) {
        hasher.Update(strings[id]);
    }

    for (const auto& metric: req.metric_keys()) {
        hasher.Update(strings[metric.name_idx()]);
        for (ui32 labelId: metric.labels_idx()) {
            hasher.Update(strings[labelId]);
        }
    }

    return hasher.Finish();
}

TString Hash(const yandex::monitoring::dataproxy::ResolveOneRequest& req) {
    THasher hasher;
    hasher.Update(std::begin(req.labels()), std::end(req.labels()));
    return hasher.Finish();
}

TString Hash(const yandex::monitoring::dataproxy::UniqueLabelsRequest& req) {
    THasher hasher;
    hasher.Update(req.selectors());
    hasher.Update(std::begin(req.keys()), std::end(req.keys()));
    return hasher.Finish();
}

} // namespace NSolomon::NDataProxy
