#pragma once

#include <util/generic/string.h>

#include <openssl/sha.h>

namespace NSolomon::NDataProxy {

class THasher {
public:
    THasher() noexcept {
        SHA1_Init(&Ctx_);
    }

    void Update(TStringBuf value) noexcept {
        SHA1_Update(&Ctx_, value.data(), value.size());
    }

    template <typename TInputIter>
    void Update(TInputIter first, TInputIter last) noexcept {
        while (first != last) {
            Update(*first);
            ++first;
        }
    }

    template <typename T, typename = std::enable_if_t<std::is_fundamental_v<T>>>
    void Update(T value) noexcept {
        SHA1_Update(&Ctx_, &value, sizeof(value));
    }

    TString Finish() {
        TString hash(SHA_DIGEST_LENGTH, '\0');
        SHA1_Final(reinterpret_cast<unsigned char*>(hash.begin()), &Ctx_);
        return hash;
    }

private:
    SHA_CTX Ctx_;
};

} // namespace NSolomon::NDataProxy
