#include "metabase_request_hash.h"

#include <solomon/libs/cpp/string_pool/string_pool.h>

namespace NSolomon::NDataProxy {

using namespace yandex::solomon::metabase;

namespace {

template <typename TSelectors>
void HashSelectors(
        THasher& hasher,
        const TSelectors& selectors)
{
    for (const auto& selector: selectors) {
        hasher.Update(selector.key());
        hasher.Update(selector.pattern());
        hasher.Update(static_cast<ui8>(selector.match_type()));
    }
}

} // namespace

/**
 * all these hashes should be in accordance with corresponding marshallers (e.g. ../datasource/lts/\*_marshaller.cpp)
 * req.deadlinemillis() is not taken into account, cause a response is still relevant even if a req's deadline differs
 */
TString Hash(const yandex::solomon::metabase::FindRequest& req) {
    THasher hasher;
    hasher.Update(req.shard_id());
    HashSelectors(hasher, req.selectors());

    if (req.has_sliceoptions()) {
        hasher.Update(req.sliceoptions().limit());
    }

    hasher.Update(req.fillmetricname());
    return hasher.Finish();
}

TString Hash(const yandex::solomon::metabase::TLabelNamesRequest& req) {
    THasher hasher;
    hasher.Update(req.shard_id());
    HashSelectors(hasher, req.selectors());
    return hasher.Finish();
}

TString Hash(const yandex::solomon::metabase::TLabelValuesRequest& req) {
    THasher hasher;
    hasher.Update(req.shard_id());
    HashSelectors(hasher, req.selectors());
    hasher.Update(std::begin(req.labels()), std::end(req.labels()));
    hasher.Update(req.limit());
    hasher.Update(req.textsearch());
    return hasher.Finish();
}

TString Hash(const yandex::solomon::metabase::MetricNamesRequest& req) {
    THasher hasher;
    hasher.Update(req.shard_id());
    HashSelectors(hasher, req.selectors().label_selectors());
    hasher.Update(req.textsearch());
    hasher.Update(req.limit());
    return hasher.Finish();
}

TString Hash(const yandex::solomon::metabase::TUniqueLabelsRequest& req) {
    THasher hasher;
    hasher.Update(req.shard_id());
    HashSelectors(hasher, req.selectors());
    hasher.Update(std::begin(req.names()), std::end(req.names()));
    return hasher.Finish();
}

TString Hash(const yandex::solomon::metabase::ResolveOneRequest& req) {
    THasher hasher;
    hasher.Update(req.name());
    for (const auto& label: req.labels()) {
        hasher.Update(label.key());
        hasher.Update(label.value());
    }
    return hasher.Finish();
}

TString Hash(const ResolveManyRequest& req) {
    THasher hasher;

    for (const auto& label: req.commonlabels()) {
        hasher.Update(label.key());
        hasher.Update(label.value());
    }

    for (const auto& metric: req.metrics()) {
        hasher.Update(metric.name());

        for (const auto& label: metric.labels()) {
            hasher.Update(label.key());
            hasher.Update(label.value());
        }
    }

    return hasher.Finish();
}

} // namespace NSolomon::NDataProxy
