#include <solomon/services/dataproxy/lib/hash/hasher.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/string/hex.h>

using namespace NSolomon::NDataProxy;

TEST(THasherTest, Empty) {
    THasher hasher;
    TString hash = hasher.Finish();

    // $ printf '' | sha1sum
    // da39a3ee5e6b4b0d3255bfef95601890afd80709  -
    EXPECT_EQ(HexEncode(hash), "DA39A3EE5E6B4B0D3255BFEF95601890AFD80709");
}

TEST(THasherTest, String) {
    THasher hasher;
    hasher.Update("test string");
    TString hash = hasher.Finish();

    // $ printf 'test string' | sha1sum
    // 661295c9cbf9d6b2f6428414504a8deed3020641  -
    EXPECT_EQ(HexEncode(hash), "661295C9CBF9D6B2F6428414504A8DEED3020641");
}

TEST(THasherTest, Array) {
    std::vector<TString> values{ "one\n", "two\n", "three\n" };

    THasher hasher;
    hasher.Update(values.begin(), values.end());
    TString hash = hasher.Finish();

    // $ echo -e 'one\ntwo\nthree' | sha1sum
    // 98ce56098daf1a2ffe03a0d108ea841f1e4e6c69  -
    EXPECT_EQ(HexEncode(hash), "98CE56098DAF1A2FFE03A0D108EA841F1E4E6C69");
}
