#pragma once

#include "events.h"

namespace NSolomon::NDataProxy {

/**
*  Publicly inheriting from TEnableInitialization<TMyActor> provides TMyActor the ability to handle InitializationEvents::TSubscribe event
*  Usage:
*
*  1. STATEFN(..) {
*         switch (ev->GetTypeRewrite()) {
*             ...
*             hFunc(TInitializationEvents::TSubscribe, OnInitializationSubscribe);
*             ...
*         }
*     }
*
*  2.  Call FinishInitialization as soon as you complete initialization
**/
template <typename TDerived>
class TEnableInitialization {
protected:
    void OnInitializationSubscribe(TInitializationEvents::TSubscribe::TPtr& ev) {
        if (IsInitialized_) {
            TAccessor::CallSend(static_cast<TDerived*>(this), ev->Sender, new TInitializationEvents::TInitialized);
        } else {
            InitializationSubscribers_.push_back(ev->Sender);
        }
    }

    void FinishInitialization() {
        IsInitialized_ = true;
        for (auto&& subscriber: InitializationSubscribers_) {
            TAccessor::CallSend(static_cast<TDerived*>(this), subscriber, new TInitializationEvents::TInitialized);
        }
        InitializationSubscribers_.clear();
        InitializationSubscribers_.shrink_to_fit();
    }

private:
    bool IsInitialized_ = false;
    TVector<NActors::TActorId> InitializationSubscribers_;

private:
    // It's a hack to call protected IActor::Send
    struct TAccessor: TDerived {
        static bool CallSend(TDerived* derived, const NActors::TActorId& recipient, NActors::IEventBase* ev) {
            bool (TDerived::*Send)(const NActors::TActorId&, NActors::IEventBase*, ui32, ui64, NWilson::TTraceId) const = &TAccessor::Send;
            return (derived->*Send)(recipient, ev, 0, 0, {});
        }
    };
};

} // namespace NSolomon::NDataProxy
