#pragma once

#include <solomon/services/dataproxy/lib/event_slots.h>
#include <solomon/libs/cpp/actors/events/events.h>
#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NDataProxy {

class TInitializationEvents: private TEventSlot<EEventSpace::DataProxy, ES_INITIALIZATION> {
    enum {
        Subscribe = SpaceBegin,
        Initialized,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TSubscribe: public NActors::TEventLocal<TSubscribe, Subscribe> {
    };

    struct TInitialized: public NActors::TEventLocal<TSubscribe, Initialized> {
    };
};

} // namespace NSolomon::NDataProxy
