#pragma once

#include <solomon/services/dataproxy/lib/cluster_id/cluster_id.h>
#include <solomon/services/dataproxy/lib/event_slots.h>
#include <solomon/services/dataproxy/lib/selectors/shard_selector.h>
#include <solomon/services/dataproxy/lib/shard/shard_id.h>
#include <solomon/services/dataproxy/lib/shard/shard_key.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/clients/memstore/rpc.h>

#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NDataProxy {

struct TMemStoreShard {
    NActors::TActorId ActorId;
    TShardSubKey Key;
    TShardId Id;
};

class TMemStoreClusterEvents: private TEventSlot<EEventSpace::DataProxy, ES_MEMSTORE_CLUSTER> {
    enum {
        FindShardsReq = SpaceBegin,
        FindShardsResp,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TFindShardsReq: public NActors::TEventLocal<TFindShardsReq, FindShardsReq> {
        TShardSelector Selector;

        explicit TFindShardsReq(TShardSelector selector) noexcept
            : Selector{std::move(selector)}
        {
        }
    };

    struct TFindShardsResp: public NActors::TEventLocal<TFindShardsResp, FindShardsResp> {
        TClusterId ClusterId;
        std::vector<TMemStoreShard> Shards;

        TFindShardsResp(TClusterId clusterId, std::vector<TMemStoreShard> shards) noexcept
            : ClusterId{clusterId}
            , Shards{std::move(shards)}
        {
        }
    };
};

/**
 * MemStore cluster options.
 */
struct TMemStoreClusterOptions {
    /**
     * Unique ID of the cluster, all shards of this cluster will include this ID into their responses.
     */
    TClusterId ClusterId;

    /**
     * Addresses of all nodes included in this cluster.
     */
    std::vector<TString> Addresses;

    /**
     * Implementation of the RPC interface to communicate with cluster nodes.
     */
    std::shared_ptr<NMemStore::IMemStoreClusterRpc> Rpc;

    /**
     * After this time shard will be considered expired.
     */
    TDuration ShardTtl = TDuration::Minutes(5);

    /**
     * Cluster will periodically search for expired shards, this option configures delay
     * between such operations.
     */
    TDuration CleanupDelay = TDuration::Seconds(30);

    /**
     * To find shard locations on nodes cluster will periodically get list of current
     * shards from each node, this option configures delay between such operations.
     */
    TDuration WatchDelay = TDuration::Seconds(5);
};

std::unique_ptr<NActors::IActor> MemStoreCluster(TMemStoreClusterOptions opts);

} // namespace NSolomon::NDataProxy
