#pragma once

#include <solomon/services/dataproxy/lib/event_slots.h>
#include <solomon/services/dataproxy/lib/shard/shard_info.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/clients/memstore/rpc.h>

#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NDataProxy {

class TMemStoreWatcherEvents: private TEventSlot<EEventSpace::DataProxy, ES_MEMSTORE_WATCHER> {
    enum {
        Subscribe = SpaceBegin,
        StateChanged,
        Resolve,
        ResolveResult,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    /**
     * Subscribe on shards info changes. Subscriber will receive changes on continuing basis.
     */
    struct TSubscribe: public NActors::TEventLocal<TSubscribe, Subscribe> {
    };

    /**
     * Latest changes in the location and/or status of shards.
     */
    struct TStateChanged: public NActors::TEventLocal<TStateChanged, StateChanged> {
        std::vector<TShardInfoPtr> Updated;
        std::vector<TShardId> Removed;

        TStateChanged(std::vector<TShardInfoPtr> updated, std::vector<TShardId> removed)
            : Updated{std::move(updated)}
            , Removed{std::move(removed)}
        {
        }
    };

    /**
     * Get location of particular shards.
     */
    struct TResolve: public NActors::TEventLocal<TResolve, Resolve> {
        std::vector<TShardId> Ids;

        explicit TResolve(std::vector<TShardId> ids)
            : Ids{std::move(ids)}
        {
        }
    };

    /**
     * Locations of requested shards.
     */
    struct TResolveResult: public NActors::TEventLocal<TResolveResult, ResolveResult> {
        std::vector<TShardLocation> Locations;

        explicit TResolveResult(std::vector<TShardLocation> locations)
            : Locations{std::move(locations)}
        {
        }
    };
};

std::unique_ptr<NActors::IActor> MemStoreClusterWatcher(
    std::shared_ptr<NMemStore::IMemStoreClusterRpc> rpc,
    std::vector<TString> addresses,
    TDuration updateDelay);

} // namespace NSolomon::NDataProxy
