#pragma once

#include <solomon/services/dataproxy/lib/event_slots.h>

#include <solomon/libs/cpp/actors/config/log_component.pb.h>
#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>

#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NDataProxy {

class TCacheConfig;

class TCacheEvents: private TEventSlot<EEventSpace::DataProxy, ES_MESSAGE_CACHE> {
    enum {
        Lookup = SpaceBegin,
        LookupResult,
        Store,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TLookup: public NActors::TEventLocal<TLookup, Lookup> {
        TString Project;
        // TODO: right now MessageType is used to distinguish messages in runtime. In theory,
        //  this check could be done in compile time, if:
        //  * a user could provide a type trait with all message types
        //  * TCacheEvents would then generate TLookup<TEv>, TStore<TEv> events for each of these types
        /**
         * A key which is interpreted on a client side. Used to distinguish multiple types of messages.
         * E.g. a user could lookup a Find request, a ResolveMany request, etc.
         */
        ui32 MessageType;
        TString MessageHash;
    };

    struct TLookupResult: public NActors::TEventLocal<TLookupResult, LookupResult> {
        TString Project;
        ui32 MessageType;
        bool NeedsRefresh;
        TString MessageHash;
        std::shared_ptr<const ::google::protobuf::Message> Data;
    };

    struct TStore: public NActors::TEventLocal<TStore, Store> {
        TString Project;
        ui32 MessageType;
        TString MessageHash;
        std::shared_ptr<const ::google::protobuf::Message> Data;
    };
};

struct IResponseFactory {
    virtual std::shared_ptr<google::protobuf::Message> Make(const TString& eventType) const = 0;
    virtual ~IResponseFactory() = default;
};

std::unique_ptr<NActors::IActor> CreateMessageCache(
        const TCacheConfig& config,
        std::shared_ptr<NMonitoring::IMetricRegistry> metrics,
        NSolomon::ELogComponent logComponent,
        TString component,
        std::unique_ptr<IResponseFactory> responses = nullptr);

// No-op cache. Lookup is always cache miss, store is ignored
std::unique_ptr<NActors::IActor> CreateMessageCacheStub();

} // namespace NSolomon::NDataProxy
