#pragma once

#include "rpc.h"

#include <solomon/services/dataproxy/lib/event_slots.h>
#include <solomon/services/dataproxy/lib/message_cache/message_cache.h>
#include <solomon/services/dataproxy/lib/shard/shard_info.h>

#include <solomon/libs/cpp/actors/events/events.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/event_local.h>

#include <memory>

namespace NSolomon::NDataProxy {

class TMetabaseShardActorEvents: private TEventSlot<EEventSpace::DataProxy, ES_METABASE_SHARD_ACTOR> {
private:
    enum {
        ShardUpdate = SpaceBegin,
        CancelRequest,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TShardUpdate: public NActors::TEventLocal<TShardUpdate, ShardUpdate> {
        TShardInfoPtr ShardInfo;

        explicit TShardUpdate(TShardInfoPtr shardInfo)
            : ShardInfo{std::move(shardInfo)}
        {}
    };

    struct TCancelRequest: public NActors::TEventLocal<TCancelRequest, CancelRequest> {
    };
};

struct IShardActorFactory {
    virtual ~IShardActorFactory() = default;

    virtual std::unique_ptr<NActors::IActor> Create(
            TString project,
            IMetabaseClusterRpcPtr rpc,
            const TShardLocation& shard,
            size_t maxInflight,
            NActors::TActorId cache) = 0;
};

std::shared_ptr<IShardActorFactory> CreateShardActorFactory(TString replica, NActors::TActorId schedulerId);

} // namespace NSolomon::NDataProxy
