#pragma once

#include <solomon/services/dataproxy/lib/metabase/events.h>
#include <solomon/services/dataproxy/lib/metabase/stub/rpc_stub.h>

#include <util/string/builder.h>

namespace NSolomon::NDataProxy {

using namespace yandex::solomon::metabase;
using namespace yandex::solomon::model;

class TRpcStub {
public:
    TRpcStub() {
        OkResponse.set_status(EMetabaseStatusCode::OK);
        OkResponse.set_totalcount(5);
        for (int i = 0; i < 5; ++i) {
            auto* m = OkResponse.add_metrics();
            m->set_type(static_cast<MetricType>(static_cast<int>(MetricType::DGAUGE) + i));
            m->set_name(TStringBuilder{} << "metric" << i);

            for (int j = 0; j < 3; ++j) {
                auto* l = m->add_labels();
                l->set_key(TStringBuilder{} << "key" << j);
                l->set_value(TStringBuilder{} << "value" << j);
            }
        }

        NotFoundResponse.set_status(EMetabaseStatusCode::SHARD_NOT_FOUND);
        NotFoundResponse.set_statusmessage("shard XXX not found");

        Rpc = StubMetabaseRpc(
            {
                {"find-ok", TStubMetabaseHandlers{
                    .OnFind = [ok{OkResponse}](const auto& req) {
                        Y_ENSURE(req.shard_id() != 0);
                        return MetabaseResponse(ok);
                    }
                }},
                {"find-ok-2", TStubMetabaseHandlers{
                    .OnFind = [ok{OkResponse}](const auto& req) {
                        Y_ENSURE(req.shard_id() != 0);
                        return MetabaseResponse(ok);
                    }
                }},
                {"find-not-found", TStubMetabaseHandlers{
                    .OnFind = [notFound{NotFoundResponse}](const auto& req) {
                        Y_ENSURE(req.shard_id() != 0);
                        return MetabaseResponse(notFound);
                    }
                }},
                {"find-rpc-error", TStubMetabaseHandlers{
                    .OnFind = [](const auto & req) {
                        Y_ENSURE(req.shard_id() != 0);
                        auto rpcCode = grpc::StatusCode::INTERNAL;
                        auto metabaseCode = EMetabaseStatusCode::INTERNAL_ERROR;
                        return MetabaseErrorResponse<FindResponse>(rpcCode, metabaseCode, "internal error");
                    }
                }},
                {"find-fail", TStubMetabaseHandlers{
                    .OnFind = [](const auto& req) {
                        Y_ENSURE(req.shard_id() != 0);
                        return MetabaseFailedResponse<TAsyncFindResponse>("unexpected error Y");
                    }
                }},
                {"find-retryable-error", TStubMetabaseHandlers{
                    .OnFind = [retry = 0u, ok{OkResponse}, notFound{NotFoundResponse}](const auto& req) mutable {
                        Y_ENSURE(req.shard_id() != 0);
                        retry++;
                        if (retry == 1) {
                            // retryable rpc error
                            auto rpcCode = grpc::StatusCode::UNAVAILABLE;
                            auto metabaseCode = EMetabaseStatusCode::NODE_UNAVAILABLE;
                            return MetabaseErrorResponse<FindResponse>(rpcCode, metabaseCode, "node Z unavailable");
                        }
                        if (retry == 2) {
                            // retryable metabase error response
                            return MetabaseResponse(notFound);
                        }
                        // ok response
                        return MetabaseResponse(ok);
                    }
                }},
                {"find-timeout", TStubMetabaseHandlers{
                    .OnFind = [](auto&&) {
                        using TErrOrValue = TMetabaseAsyncResponse<FindResponse>::value_type;
                        auto promise = NThreading::NewPromise<TErrOrValue>();
                        return promise.GetFuture(); // will never be resolved
                    }
                }},
                {"find-paging", TStubMetabaseHandlers{
                    .OnFind = [ok{OkResponse}](const auto& req) mutable {
                        Y_ENSURE(req.shard_id() != 0);
                        ok.set_totalcount(100);
                        return MetabaseResponse(ok);
                    }
                }},
            });
    }

public:
    FindResponse OkResponse;
    FindResponse NotFoundResponse;

    IMetabaseClusterRpcPtr Rpc;
};

} // namespace NSolomon::NDataProxy

