#pragma once

#include "rpc.h"

#include <solomon/services/dataproxy/lib/event_slots.h>
#include <solomon/services/dataproxy/lib/shard/shard_info.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>

#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NDataProxy {

class TMetabaseWatcherEvents: private TEventSlot<EEventSpace::DataProxy, ES_METABASE_WATCHER> {
    enum {
        Subscribe = SpaceBegin,
        StateChanged,
        Resolve,
        ResolveResult,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    /**
     * Subscribe on shards info changes. Subscriber will receive changes on continuing basis.
     */
    struct TSubscribe: public NActors::TEventLocal<TSubscribe, Subscribe> {
    };

    /**
     * Latest changes in the location and/or status of shards.
     */
    struct TStateChanged: public NActors::TEventLocal<TStateChanged, StateChanged> {
        std::vector<TShardInfoPtr> Updated;
        std::vector<TShardId> Removed;
    };

    /**
     * Get location of particular shards.
     */
    struct TResolve: public NActors::TEventLocal<TResolve, Resolve> {
        std::vector<TShardId> Ids;
    };

    /**
     * Locations of requested shards.
     */
    struct TResolveResult: public NActors::TEventLocal<TResolveResult, ResolveResult> {
        std::vector<TShardLocation> Locations;
    };
};

std::unique_ptr<NActors::IActor> MetabaseClusterWatcher(
        IMetabaseClusterRpcPtr rpc,
        std::vector<TString> addresses,
        TDuration updateDelay);

} // namespace NSolomon::NDataProxy
