#include <solomon/services/dataproxy/lib/metric/metric.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <unordered_set>

using namespace NSolomon::NDataProxy;

TEST(TMetricTest, StringEq) {
    TMetricKey<TString> m1 = {"name", {{"key", "value"}}};
    TMetricKey<TString> m2 = {"name", {{"key", "value"}}};
    TMetricKey<TString> m3 = {"name", {{"key", "v"}}};
    TMetricKey<TString> m4 = {"name", {{"k", "value"}}};
    TMetricKey<TString> m5 = {"n", {{"key", "value"}}};

    EXPECT_EQ(m1, m2);
    EXPECT_NE(m1, m3);
    EXPECT_NE(m1, m4);
    EXPECT_NE(m1, m5);
}

TEST(TMetricTest, StringHash) {
    TMetricKey<TString> m1 = {"name", {{"key", "value"}}};
    TMetricKey<TString> m2 = {"name", {{"key", "value"}}};
    TMetricKey<TString> m3 = {"name", {{"key", "v"}}};
    TMetricKey<TString> m4 = {"name", {{"k", "value"}}};
    TMetricKey<TString> m5 = {"n", {{"key", "value"}}};

    EXPECT_EQ(m1.Hash(), m2.Hash());
    EXPECT_NE(m1.Hash(), m3.Hash());
    EXPECT_NE(m1.Hash(), m4.Hash());
    EXPECT_NE(m1.Hash(), m5.Hash());

    std::unordered_set<TMetricKey<TString>> keys;
    keys.insert({m1, m2, m3, m4, m5});
    EXPECT_EQ(4u, keys.size());
}

TEST(TMetricTest, NumEq) {
    TMetricKey<ui32> m1 = {1, {{2, 3}}};
    TMetricKey<ui32> m2 = {1, {{2, 3}}};
    TMetricKey<ui32> m3 = {1, {{2, 333}}};
    TMetricKey<ui32> m4 = {1, {{222, 3}}};
    TMetricKey<ui32> m5 = {111, {{2, 3}}};

    EXPECT_EQ(m1, m2);
    EXPECT_NE(m1, m3);
    EXPECT_NE(m1, m4);
    EXPECT_NE(m1, m5);
}

TEST(TMetricTest, NumHash) {
    TMetricKey<ui32> m1 = {1, {{2, 3}}};
    TMetricKey<ui32> m2 = {1, {{2, 3}}};
    TMetricKey<ui32> m3 = {1, {{2, 333}}};
    TMetricKey<ui32> m4 = {1, {{222, 3}}};
    TMetricKey<ui32> m5 = {111, {{2, 3}}};

    EXPECT_EQ(m1.Hash(), m2.Hash());
    EXPECT_NE(m1.Hash(), m3.Hash());
    EXPECT_NE(m1.Hash(), m4.Hash());
    EXPECT_NE(m1.Hash(), m5.Hash());

    std::unordered_set<TMetricKey<ui32>> keys;
    keys.insert({m1, m2, m3, m4, m5});
    EXPECT_EQ(4u, keys.size());
}

TEST(TMetricTest, DefaultInitialized) {
    TLabel<ui32> label;
    EXPECT_EQ(label.Key, 0u);
    EXPECT_EQ(label.Value, 0u);

    TMetricKey<ui32> metricKey;
    EXPECT_EQ(metricKey.Name, 0u);

    TMetric<ui32> metric;
    EXPECT_EQ(metric.Name, 0u);
    EXPECT_EQ(metric.Type, NMonitoring::EMetricType::UNKNOWN);
}
