#pragma once

#include <solomon/services/dataproxy/lib/datasource/query.h>
#include <solomon/services/dataproxy/lib/datasource/result_handler.h>
#include <solomon/services/dataproxy/lib/event_slots.h>

#include <solomon/libs/cpp/actors/events/events.h>

#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/actors/core/actorsystem.h>

namespace NSolomon::NDataProxy {

class TMetricsTracking: private TEventSlot<EEventSpace::DataProxy, ES_METRICS_TRACKING> {
    enum {
        FindReq = SpaceBegin,
        FindResp,
        ReadManyReq,
        ReadManyResp,
        LabelValuesReq,
        LabelValuesResp,
        Error,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

    template <typename TPayload>
    static constexpr auto EventType() noexcept {
        if constexpr (std::is_same_v<TPayload, TFindQuery>) return FindReq;
        else if constexpr (std::is_same_v<TPayload, TFindResult>) return FindResp;
        else if constexpr (std::is_same_v<TPayload, TReadManyQuery>) return ReadManyReq;
        else if constexpr (std::is_same_v<TPayload, TReadManyResult>) return ReadManyResp;
        else if constexpr (std::is_same_v<TPayload, TLabelValuesQuery>) return LabelValuesReq;
        else if constexpr (std::is_same_v<TPayload, TLabelValuesResult>) return LabelValuesResp;
        else if constexpr (std::is_same_v<TPayload, TDataSourceError>) return Error;
        else static_assert(TDependentFalse<TPayload>, "unsupported type");
    }

public:
    template <typename TPayload>
    struct TMessage: public NActors::TEventLocal<TMessage<TPayload>, EventType<TPayload>()> {
        TMessage(TPayload payload, TString stage) noexcept
            : Payload{std::move(payload)}
            , Stage{std::move(stage)}
        {
        }

        TPayload Payload;
        TString Stage;
    };
};

} // namespace NSolomon::NDataProxy
