#include "point_to_string.h"

#include <library/cpp/monlib/metrics/histogram_snapshot.h>
#include <util/string/builder.h>
#include <util/string/cast.h>

namespace NSolomon::NDataProxy {

namespace {

TString PointToString(const NTs::NValue::THistogram& hist) {
    TStringBuilder sb;
    sb << "{";
    for (size_t i = 0; i < hist.Buckets.size(); ++i) {
        if (hist.Buckets[i].UpperBound == NMonitoring::HISTOGRAM_INF_BOUND) {
            sb << "inf";
        } else {
            sb << hist.Buckets[i].UpperBound;
        }

        sb << ": " << hist.Buckets[i].Value;

        if (i + 1 != hist.Buckets.size()) {
            sb << ", ";
        }
    }
    sb << "}";

    return sb;
}

TString PointToString(const NTs::NValue::TLogHistogram& hist) {
    TStringBuilder sb;
    sb << "{zeros: " << hist.ZeroCount << ", startPower: " << hist.StartPower << ", values: [";
    for (size_t i = 0; i < hist.Values.size(); ++i) {
        sb << hist.Values[i];
        if (i + 1 != hist.Values.size()) {
            sb << ", ";
        }
    }
    sb << "]}";

    return sb;
}

template <typename T>
TString PointToString(const NTs::NValue::TSummary<T>& s) {
    TStringBuilder sb;
    sb << "{"
        << "sum: " << s.Sum << ", min: " << s.Min << ", max: " << s.Max << ", last: " << s.Last
        << ", count: " << s.CountValue << "}";

    return sb;
}

TString PointToString(const NTs::NValue::TDouble& d) {
    return ToString(d.ValueDivided());
}

TString PointToString(const NTs::NValue::TLong& l) {
    return ToString(l.Value);
}

} // namespace

TString PointToString(const NTs::TVariantPoint& point) {
    return std::visit([](auto&& value){
        return PointToString(value);
    }, point.Value);
}

} // namespace NSolomon::NDataProxy
