#pragma once

#include <solomon/libs/cpp/selfmon/selfmon.h>
#include <solomon/services/dataproxy/lib/datasource/datasource.h>

namespace NSolomon::NDataProxy {

void AddQueryFieldsBase(const TQuery&, yandex::monitoring::selfmon::Object*);
void AddQueryFields(const TFindQuery&, yandex::monitoring::selfmon::Object*, NSelfMon::TEvPageDataReq*);
void AddQueryFields(const TReadManyQuery&, yandex::monitoring::selfmon::Object*, NSelfMon::TEvPageDataReq*);
void AddQueryFields(const TLabelValuesQuery&, yandex::monitoring::selfmon::Object*, NSelfMon::TEvPageDataReq*);
void AddResultFields(const TFindResult&, yandex::monitoring::selfmon::Object*, NSelfMon::TEvPageDataReq*);
void AddResultFields(const TReadManyResult&, yandex::monitoring::selfmon::Object*, NSelfMon::TEvPageDataReq*);
void AddResultFields(const TLabelValuesResult&, yandex::monitoring::selfmon::Object*, NSelfMon::TEvPageDataReq*);
void RenderField(const TFindQuery&, yandex::monitoring::selfmon::Grid*, NSelfMon::TEvPageDataReq*);
void RenderField(const TReadManyQuery&, yandex::monitoring::selfmon::Grid*, NSelfMon::TEvPageDataReq*);
void RenderField(const TLabelValuesQuery&, yandex::monitoring::selfmon::Grid*, NSelfMon::TEvPageDataReq*);
void RenderField(const TFindResult&, yandex::monitoring::selfmon::Grid*, NSelfMon::TEvPageDataReq*);
void RenderField(const TReadManyResult&, yandex::monitoring::selfmon::Grid*, NSelfMon::TEvPageDataReq*);
void RenderField(const TLabelValuesResult&, yandex::monitoring::selfmon::Grid*, NSelfMon::TEvPageDataReq*);

template <typename TResultType>
void RenderEvent(const TResultType& result, yandex::monitoring::selfmon::Grid* grid, NSelfMon::TEvPageDataReq* req) {
    if (req->Param("field")) {
        RenderField(result, grid, req);
        return;
    }

    auto* o = grid->add_rows()->add_columns()->mutable_component()->mutable_object();
    AddResultFields(result, o, req);
}

template <typename TQueryType>
requires std::derived_from<TQueryType, TQuery>
void RenderEvent(const TQueryType& query, yandex::monitoring::selfmon::Grid* grid, NSelfMon::TEvPageDataReq* req) {
    if (req->Param("field")) {
        RenderField(query, grid, req);
        return;
    }

    auto* o = grid->add_rows()->add_columns()->mutable_component()->mutable_object();
    AddQueryFieldsBase(query, o);
    AddQueryFields(query, o, req);
}

inline void RenderEvent(const TDataSourceError&, yandex::monitoring::selfmon::Grid*, NSelfMon::TEvPageDataReq*) {
}

template <typename T>
void RenderHeader(const T& event, TStringBuf stage, yandex::monitoring::selfmon::Grid* grid) {
    auto* h = grid->add_rows()->add_columns()->mutable_component()->mutable_heading();
    h->set_level(3);
    h->set_content(TString{stage} + ": " + EventDecription(event));
}

template <typename TEvent>
TString EventDecription(const TEvent& event) {
    if constexpr (std::is_same_v<TEvent, TFindQuery>) return "FindQuery";
    else if constexpr (std::is_same_v<TEvent, TFindResult>) return "FindResult";
    else if constexpr (std::is_same_v<TEvent, TReadManyQuery>) return "ReadManyQuery";
    else if constexpr (std::is_same_v<TEvent, TReadManyResult>) return "ReadManyResult";
    else if constexpr (std::is_same_v<TEvent, TLabelValuesQuery>) return "LabelValuesQuery";
    else if constexpr (std::is_same_v<TEvent, TLabelValuesResult>) return "LabelValuesResult";
    else if constexpr (std::is_same_v<TEvent, TDataSourceError>) return TStringBuilder{} << event.Status << ": " << event.Message;
    else static_assert(TDependentFalse<TEvent>, "unsupported type");
}

} // namespace NSolomon::NDataProxy
