#include "shard_info.h"

#include <util/stream/output.h>

namespace NSolomon::NDataProxy {

IOutputStream& operator<<(IOutputStream& os, const TShardLocation& location) {
    return os << "{id: " << location.Id << ", address: " << location.Address << '}';
}

IOutputStream& operator<<(IOutputStream& os, const TShardInfo& info) {
    return os << "{id: " << info.Id
            << ", address: " << info.Address
            << ", key: " << info.Key
            << ", ready: " << info.Ready
            << '}';
}

} // namespace NSolomon::NDataProxy
