#pragma once

#include "shard_id.h"
#include "shard_key.h"

namespace NSolomon::NDataProxy {

struct TShardLocation {
    TShardId Id{0};
    TString Address;

    TShardLocation() noexcept = default;

    TShardLocation(TShardId id, TString address) noexcept
        : Id{id}
        , Address{std::move(address)}
    {
    }

    bool operator==(const TShardLocation& rhs) const noexcept = default;
    bool operator!=(const TShardLocation& rhs) const noexcept = default;
};

struct TShardInfo {
    const TShardId Id{0};
    TString Address;
    const TShardKey Key;
    bool Ready{false};

    TShardInfo() noexcept = default;

    TShardInfo(TShardId id, TString address, TShardKey key, bool ready)
        : Id{id}
        , Address{std::move(address)}
        , Key{std::move(key)}
        , Ready{ready}
    {}

    bool operator==(const TShardInfo&) const noexcept = default;
    bool operator!=(const TShardInfo&) const noexcept = default;
};

using TShardInfoPtr = std::shared_ptr<const TShardInfo>;

IOutputStream& operator<<(IOutputStream& os, const TShardLocation& location);
IOutputStream& operator<<(IOutputStream& os, const TShardInfo& info);

} // namespace NSolomon::NDataProxy
