#include "shard_key.h"

#include <util/stream/output.h>

namespace NSolomon::NDataProxy {

IOutputStream& operator<<(IOutputStream& os, const TShardSubKey& subKey) {
    return os << "{cluster: " << subKey.Cluster << ", service: " << subKey.Service << '}';
}

IOutputStream& operator<<(IOutputStream& os, const TShardKey& key) {
    return os << "{project: " << key.Project
            << ", cluster: " << key.SubKey.Cluster
            << ", service: " << key.SubKey.Service
            << '}';
}

} // namespace NSolomon::NDataProxy
