#pragma once

#include "shard_info.h"
#include "shard_key.h"

#include <solomon/services/dataproxy/lib/selectors/shard_selector.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>

namespace NSolomon::NDataProxy {

class TShardsMap {
    using TProjectShards = absl::flat_hash_map<TShardSubKey, TShardInfoPtr>;

public:
    bool Update(const TShardInfoPtr& shard);
    TShardInfoPtr Remove(const TShardId& id);

    std::optional<TShardLocation> FindExact(const TShardSelector& selector) const;

    TShardInfoPtr FindExactInfo(const TShardSelector& selector) const;

    std::vector<TShardLocation> Find(const TShardSelector& selector) const;

    std::vector<TShardInfoPtr> FindInfo(const TShardSelector& selector) const;

    size_t Size() const noexcept {
        return ShardsById_.size();
    }

private:
    absl::flat_hash_map<TShardId, TShardInfoPtr> ShardsById_;
    absl::flat_hash_map<TString, TProjectShards> Shards_;
};

} // namespace NSolomon::NDataProxy
