#pragma once

#include <solomon/services/dataproxy/lib/event_slots.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/protos/stockpile/stockpile_read.pb.h>
#include <solomon/services/dataproxy/lib/selectors/shard_selector.h>

#include <library/cpp/actors/core/event_local.h>

#include <grpc++/support/status_code_enum.h>

#include <util/generic/typelist.h>

namespace NSolomon::NDataProxy {

class TStockpileEvents: private TEventSlot<EEventSpace::DataProxy, ES_STOCKPILE_CLUSTER> {
    template <typename TDerived, typename TMessage, ui32 Type>
    struct TRequest: public NActors::TEventLocal<TDerived, Type> {
        TInstant Deadline;
        TMessage Message;

        TRequest() = default;

        TRequest(const TRequest& rhs)
                : Message{rhs.Message}
                , Deadline{rhs.Deadline}
        {
        }

        TRequest(TRequest&& rhs)
                : Message{std::move(rhs.Message)}
                , Deadline{rhs.Deadline}
        {
        }
    };

    template <typename TDerived, typename TMessage, ui32 Type>
    struct TResponse: public NActors::TEventLocal<TDerived, Type> {
        TMessage Message;
    };

    enum {
        ReadManyReq = SpaceBegin,
        ReadManyResp,
        ReadOneReq,
        ReadOneResp,
        Error,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TReadManyReq: public TRequest<TReadManyReq, yandex::solomon::stockpile::TReadManyRequest, ReadManyReq>{};
    struct TReadManyResp: public TResponse<TReadManyResp, yandex::solomon::stockpile::TCompressedReadManyResponse, ReadManyResp>{};

    struct TReadOneReq: public TRequest<TReadOneReq, yandex::solomon::stockpile::TReadRequest, ReadOneReq>{};
    struct TReadOneResp: public TResponse<TReadOneResp, yandex::solomon::stockpile::TCompressedReadResponse, ReadOneResp>{};

    using TListOfReqAndResp = TTypeList<
            std::pair<TReadOneReq, TReadOneResp>,
            std::pair<TReadManyReq, TReadManyResp>
    >;

    struct TError: public NActors::TEventLocal<TError, Error> {
        grpc::StatusCode RpcCode;
        yandex::solomon::stockpile::EStockpileStatusCode StockpileCode;
        TString Message;
    };

    template <typename TReq>
    struct TIsKnownReq {
        template <typename TReqAndResp>
        using TResult = TBoolConstant<std::is_same_v<TReq, typename TReqAndResp::first_type>>;
    };

    template <typename TResp>
    struct TIsKnownResp {
        template <typename TReqAndResp>
        using TResult = TBoolConstant<std::is_same_v<TResp, typename TReqAndResp::second_type>>;
    };

    template <typename TReq>
    struct TRequestToResponse {
        using TResponse = typename TListOfReqAndResp::TSelectBy<TIsKnownReq<TReq>::template TResult>::type::second_type;
    };

    template <typename TResp>
    struct TResponseToRequest {
        using TRequest = typename TListOfReqAndResp::TSelectBy<TIsKnownResp<TResp>::template TResult>::type::first_type;
    };
};

} // namespace NSolomon::NDataProxy
