#include "shards.h"

#include <util/stream/output.h>

namespace NSolomon::NDataProxy {

void TStockpileShardInfo::PrintTo(IOutputStream& out) const {
    out << TStringBuf("{id: ") << Id
        << TStringBuf(", ready: ") << (Ready ? TStringBuf("true") : TStringBuf("false"))
        << TStringBuf(", location: ") << Location
        << '}';
}

} // namespace NSolomon::NDataProxy

using NSolomon::NDataProxy::TStockpileShardInfo;

template <>
void Out<TStockpileShardInfo>(IOutputStream& out, const TStockpileShardInfo& s) {
    s.PrintTo(out);
}
