#pragma once

#include <util/generic/string.h>

#include <unordered_map>

namespace NSolomon::NDataProxy {

/**
 * Unique identifier of Stockpile shard.
 */
using TStockpileShardId = ui16;

/**
 * Basic information about Stockpile shard.
 */
struct TStockpileShardInfo {
    /**
     * Shard identifier.
     */
    TStockpileShardId Id{0};

    /**
     * Does this shard is ready for read.
     */
    bool Ready{false};

    /**
     * FQDN of a host where this shard is located.
     */
    TString Location;

    /**
     * Prints current shard to given output stream.
     */
    void PrintTo(IOutputStream& out) const;
};

using TStockpileShardsMap = std::unordered_map<TStockpileShardId, TStockpileShardInfo>;

} // namespace NSolomon::NDataProxy
