#pragma once

#include <solomon/services/dataproxy/lib/stockpile/rpc.h>

namespace NSolomon::NDataProxy {

template <typename T>
T StockpileFailedResponse(const TString& message) {
    using TType = typename NThreading::TFutureType<T>;
    return NThreading::MakeErrorFuture<TType>(std::make_exception_ptr(yexception() << message));
}

template <typename TResp, typename... Args>
TStockpileAsyncResponse<TResp> StockpileErrorResponse(Args... args) {
    return NThreading::MakeFuture(TErrorOr<TResp, TStockpileError>::FromError(
            TStockpileError{std::forward<Args>(args)...}
    ));
}

template <typename TResp>
TStockpileAsyncResponse<TResp> StockpileResponse(TResp response) {
    return NThreading::MakeFuture(TErrorOr<TResp, TStockpileError>::FromValue(response));
}

/**
 * Stub Stockpile RPC handlers.
 *
 * If particular handler is not set, then method will return TFuture completed with an exception
 */
struct TStubStockpileHandlers {
    std::function<TAsyncStockpileStatusResponse(const yandex::solomon::stockpile::TServerStatusRequest&)> OnServerStatus;
    std::function<TAsyncReadResponse(const yandex::solomon::stockpile::TReadRequest&)> OnReadOne;
    std::function<TAsyncUncompressedReadManyResponse(const yandex::solomon::stockpile::TReadManyRequest&)> OnReadUncompressedMany;
    std::function<TAsyncCompressedReadResponse(const yandex::solomon::stockpile::TReadRequest&)> OnReadCompressedOne;
    std::function<TAsyncCompressedReadManyResponse(const yandex::solomon::stockpile::TReadManyRequest&)> OnReadCompressedMany;
    std::function<TAsyncReadMetricsMetaResponse(const yandex::solomon::stockpile::ReadMetricsMetaRequest&)> OnReadMetricsMeta;
};

/**
 * Create stub Stockpile cluster RPC.
 *
 * @param nodes  map of { node address -> handlers }
 * @return instance of fake Stockpile cluster RPC implementation.
 */
IStockpileClusterRpcPtr StubStockpileRpc(THashMap<TString, TStubStockpileHandlers> nodes);

} // namespace NSolomon::NDataProxy
