#pragma once

#include "rpc.h"
#include "shards.h"
#include <solomon/services/dataproxy/lib/event_slots.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>

#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NDataProxy {

class TStockpileWatcherEvents: private TEventSlot<EEventSpace::DataProxy, ES_STOCKPILE_WATCHER> {
    enum {
        Created = SpaceBegin,
        Subscribe,
        Update,
        Resolve,
        ResolveResult,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    /**
     * Subscribe on shards info changes. Subscriber will receive changes on continuing basis.
     */
    struct TSubscribe: public NActors::TEventLocal<TSubscribe, Subscribe> {
    };

    /**
     * Latest changes in the location and/or status of shards.
     */
    struct TUpdate: public NActors::TEventLocal<TUpdate, Update> {
        std::vector<TStockpileShardInfo> Shards;
    };

    /**
     * Get info about particular shards.
     */
    struct TResolve: public NActors::TEventLocal<TResolve, Resolve> {
        std::vector<TStockpileShardId> Ids;
    };

    /**
     * Information about requested shards.
     */
    struct TResolveResult: public NActors::TEventLocal<TResolveResult, ResolveResult> {
        std::vector<TStockpileShardInfo> Shards;
        std::vector<TStockpileShardId> NotFound;
    };
};

/**
 * Create actor which will watch Stockpile shards on particular hosts.
 *
 * @param rpc           Stockpile cluster RPC implementation
 * @param addresses     list of hosts to watch
 * @param updateDelay   minimal duration between updates
 * @return created actor
 */
std::unique_ptr<NActors::IActor> StockpileClusterWatcher(
        IStockpileClusterRpcPtr rpc,
        std::vector<TString> addresses,
        TDuration updateDelay);

} // namespace NSolomon::NDataProxy
