#pragma once

#include <solomon/libs/cpp/ts_codec/points.h>
#include <solomon/protos/math/aggregate.pb.h>
#include <solomon/protos/math/aggregation.pb.h>
#include <solomon/protos/stockpile/metric_data.pb.h>

#include <variant>

namespace NSolomon::NDataProxy {

template <typename T>
struct TAggregateScalar {
    T Max;
    T Min;
    T Sum;
    T Avg;
    T Last;

    bool operator==(const TAggregateScalar<T>&) const = default;
};

template <typename T>
struct TAggregate {
    T Last;
    T Sum;

    bool operator==(const TAggregate<T>&) const = default;
};

using TAggregateDouble = TAggregateScalar<double>;
using TAggregateInt64 = TAggregateScalar<i64>;
using TAggregateSummaryDouble = TAggregate<NTs::NValue::TSummaryDouble>;
using TAggregateSummaryInt64 = TAggregate<NTs::NValue::TSummaryInt>;
using TAggregateHistogram = TAggregate<NTs::NValue::THistogram>;
using TAggregateLogHistogram = TAggregate<NTs::NValue::TLogHistogram>;

struct TAggregateVariant {
    using TValue = std::variant<
        TAggregateDouble,
        TAggregateInt64,
        TAggregateSummaryInt64,
        TAggregateSummaryDouble,
        TAggregateHistogram,
        TAggregateLogHistogram>;

    TValue Value;
    ui64 Count;
    // Mask of fields that are filled with aggregated value
    ui32 Mask; // TODO: make typesafe columns set
};

bool operator==(const TAggregateVariant& lhs, const TAggregateVariant& rhs);

void FromProto(const yandex::solomon::math::Aggregate& proto, TAggregateVariant* aggr);
void FromProto(const yandex::solomon::stockpile::MetricData& proto, TAggregateVariant* aggr);

void ToProto(const TAggregateVariant& aggr, yandex::solomon::math::Aggregate* proto);

template <typename TResp>
using TOptionalMetricProcessor = std::function<std::optional<TResp>(yandex::solomon::stockpile::MetricData*)>;

template <typename TResp>
TOptionalMetricProcessor<TResp> GetSummaryFieldExtractor(yandex::solomon::math::Aggregation aggregation);

} // namespace NSolomon::NDataProxy
