#pragma once

#include "timeseries.h"
#include "type_to_columns.h"

namespace NSolomon::NDataProxy {

struct TEmptyTimeSeriesIter final: public ITimeSeriesIter {
    bool Next(NTs::TVariantPoint* /*point*/) override {
        return false;
    }
};

class TEmptyTimeSeries final: public ITimeSeries {
public:
    explicit TEmptyTimeSeries(NMonitoring::EMetricType type)
        : Type_{type}
        , Columns_{TypeToSimpleColumns(type)}
    {
    }

    TEmptyTimeSeries(NMonitoring::EMetricType type, NTs::TColumnSet columns)
        : Type_{type}
        , Columns_{columns}
    {
        EnsureValidTypeForColumns(Type_, Columns_);
    }

    NMonitoring::EMetricType Type() const override {
        return Type_;
    }

    NTs::TColumnSet Columns() const override {
        return Columns_;
    }

    ui32 PointCount() const override {
        return 0;
    }

    std::unique_ptr<ITimeSeriesIter> Iterator() const override {
        return std::make_unique<TEmptyTimeSeriesIter>();
    }

private:
    NMonitoring::EMetricType Type_;
    NTs::TColumnSet Columns_;
};

} // namespace NSolomon::NDataProxy
