#include "merger.h"
#include "empty.h"
#include "compressed.h"

namespace NSolomon::NDataProxy {

std::unique_ptr<ITimeSeries> MergeTimeSeries(
    NMonitoring::EMetricType resultType,
    std::vector<std::unique_ptr<ITimeSeries>> input)
{
    if (input.empty()) {
        return std::make_unique<TEmptyTimeSeries>(resultType);
    }

    if (input.size() == 1) {
        // TODO: convert type if time series differs from resultType
        return std::move(input[0]);
    }

    TMergingIterator<TMaxMerger> it;
    for (auto& ts: input) {
        it.AddTimeSeries(*ts);
    }

    return std::make_unique<TCompressedTimeSeries>(resultType, it.Columns(), it);
}

} // namespace NSolomon::NDataProxy
