#pragma once

#include "compressed.h"

#include <solomon/libs/cpp/stockpile_codec/format.h>

#include <solomon/protos/model/timeseries.pb.h>
#include <solomon/protos/stockpile/metric_data.pb.h>
#include <solomon/protos/stockpile/stockpile_requests.pb.h>

namespace NSolomon::NDataProxy {

void ToProto(const TCompressedTimeSeries& timeSeries, yandex::solomon::model::TimeSeries* proto, NStockpile::EFormat format);

// will compress time series before serialization
void ToProto(const ITimeSeries& timeSeries, yandex::solomon::model::TimeSeries* proto, NStockpile::EFormat format);

std::unique_ptr<ITimeSeries> FromProto(
        yandex::solomon::model::MetricType type,
        const yandex::solomon::model::TimeSeries& proto);

std::unique_ptr<ITimeSeries> FromProto(
        NMonitoring::EMetricType typeFallback,
        const yandex::solomon::stockpile::TCompressedReadResponse& response);

// only compressed time series is supported
std::unique_ptr<ITimeSeries> FromProto(
        NMonitoring::EMetricType typeFallback,
        const yandex::solomon::stockpile::MetricData& metricData);

} // namespace NSolomon::NDataProxy
