#pragma once

#include <solomon/libs/cpp/ts_codec/points.h>

#include <library/cpp/monlib/metrics/metric_type.h>

namespace NSolomon::NDataProxy {

/**
 * Interface of time series iterator.
 */
struct ITimeSeriesIter {
    virtual ~ITimeSeriesIter() = default;

    virtual bool Next(NTs::TVariantPoint* point) = 0;
};

/**
 * Interface of immutable time series.
 */
struct ITimeSeries {
    virtual ~ITimeSeries() = default;

    virtual NMonitoring::EMetricType Type() const = 0;

    virtual NTs::TColumnSet Columns() const = 0;

    virtual ui32 PointCount() const = 0;

    virtual std::unique_ptr<ITimeSeriesIter> Iterator() const = 0;
};

} // namespace NSolomon::NDataProxy
