#pragma once

#include <solomon/libs/cpp/ts_codec/points.h>

#include <library/cpp/monlib/metrics/metric_type.h>

namespace NSolomon::NDataProxy {

inline constexpr std::array MinColumnsByType = {
    NTs::TColumnSet{},                      // UNKNOWN
    NTs::TDoublePoint::MinColumns,          // GAUGE
    NTs::TLongPoint::MinColumns,            // COUNTER
    NTs::TLongPoint::MinColumns,            // RATE
    NTs::TLongPoint::MinColumns,            // IGAUGE
    NTs::THistogramPoint::MinColumns,       // HIST
    NTs::THistogramPoint::MinColumns,       // HIST_RATE
    NTs::TSummaryDoublePoint::MinColumns,   // DSUMMARY
    NTs::TSummaryIntPoint::MinColumns,      // ISUMMARY
    NTs::TLogHistogramPoint::MinColumns,    // LOGHIST
};

inline constexpr std::array SimpleColumnsByType = {
    NTs::TColumnSet{},                       // UNKNOWN
    NTs::TDoublePoint::SimpleColumns,        // GAUGE
    NTs::TLongPoint::SimpleColumns,          // COUNTER
    NTs::TLongPoint::SimpleColumns,          // RATE
    NTs::TLongPoint::SimpleColumns,          // IGAUGE
    NTs::THistogramPoint::SimpleColumns,     // HIST
    NTs::THistogramPoint::SimpleColumns,     // HIST_RATE
    NTs::TSummaryDoublePoint::SimpleColumns, // DSUMMARY
    NTs::TSummaryIntPoint::SimpleColumns,    // ISUMMARY
    NTs::TLogHistogramPoint::SimpleColumns,  // LOGHIST
};

inline constexpr std::array AggrColumnsByType = {
    NTs::TColumnSet{},                       // UNKNOWN
    NTs::TDoublePoint::AggrColumns,          // GAUGE
    NTs::TLongPoint::AggrColumns,            // COUNTER
    NTs::TLongPoint::AggrColumns,            // RATE
    NTs::TLongPoint::AggrColumns,            // IGAUGE
    NTs::THistogramPoint::AggrColumns,       // HIST
    NTs::THistogramPoint::AggrColumns,       // HIST_RATE
    NTs::TSummaryDoublePoint::AggrColumns,   // DSUMMARY
    NTs::TSummaryIntPoint::AggrColumns,      // ISUMMARY
    NTs::TLogHistogramPoint::AggrColumns,    // LOGHIST
};

constexpr NTs::TColumnSet TypeToMinColumns(NMonitoring::EMetricType type) {
    return MinColumnsByType[ToUnderlying(type)];
}

constexpr NTs::TColumnSet TypeToSimpleColumns(NMonitoring::EMetricType type) {
    return SimpleColumnsByType[ToUnderlying(type)];
}

constexpr NTs::TColumnSet TypeToAggrColumns(NMonitoring::EMetricType type) {
    return AggrColumnsByType[ToUnderlying(type)];
}

inline bool IsValidTypeForColumns(NMonitoring::EMetricType type, NTs::TColumnSet columns) {
    size_t idx = ToUnderlying(type);
    if ((MinColumnsByType[idx] & columns) != MinColumnsByType[idx]) {
        return false;
    }
    if ((~AggrColumnsByType[idx] & columns) != NTs::TColumnSet{}) {
        return false;
    }
    return true;
}

inline void EnsureValidTypeForColumns(NMonitoring::EMetricType type, NTs::TColumnSet columns) {
    Y_ENSURE(IsValidTypeForColumns(type, columns),
            "used invalid combination of metric type " << type << " and columns " << columns);
}

} // namespace NSolomon::NDataProxy
