#include "points.h"

#include <solomon/services/dataproxy/lib/timeseries/compressed.h>
#include <solomon/services/dataproxy/lib/timeseries/vector.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NDataProxy;
using namespace NMonitoring;

TEST(TCompressedTimeSeriesTest, Copy) {
    TVectorTimeSeries<NTs::TLongPoint> vecTs{EMetricType::RATE, {
        LongPoint("2020-01-02T03:04:05Z", 1),
        LongPoint("2020-01-02T03:04:10Z", 2),
        LongPoint("2020-01-02T03:04:15Z", 3),
        LongPoint("2020-01-02T03:04:20Z", 4),
    }};

    // make compressed copy
    TCompressedTimeSeries cmpTs{vecTs};

    EXPECT_EQ(cmpTs.Type(), vecTs.Type());
    EXPECT_EQ(cmpTs.Columns(), vecTs.Columns());
    EXPECT_EQ(cmpTs.PointCount(), vecTs.PointCount());

    NTs::TVariantPoint point;
    auto it = cmpTs.Iterator();
    ASSERT_TRUE(it);

    ASSERT_TRUE(it->Next(&point));
    EXPECT_EQ(point.Time, vecTs[0].Time);
    EXPECT_EQ(point.Get<NTs::NValue::TLong>().Value, vecTs[0].Value);

    ASSERT_TRUE(it->Next(&point));
    EXPECT_EQ(point.Time, vecTs[1].Time);
    EXPECT_EQ(point.Get<NTs::NValue::TLong>().Value, vecTs[1].Value);

    ASSERT_TRUE(it->Next(&point));
    EXPECT_EQ(point.Time, vecTs[2].Time);
    EXPECT_EQ(point.Get<NTs::NValue::TLong>().Value, vecTs[2].Value);

    ASSERT_TRUE(it->Next(&point));
    EXPECT_EQ(point.Time, vecTs[3].Time);
    EXPECT_EQ(point.Get<NTs::NValue::TLong>().Value, vecTs[3].Value);

    ASSERT_FALSE(it->Next(&point));
}
