#include <solomon/services/dataproxy/lib/timeseries/empty.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NDataProxy;
using namespace NMonitoring;

TEST(TEmptyTimeSeriesTest, Interface) {
    TEmptyTimeSeries timeSeries{EMetricType::GAUGE};

    EXPECT_EQ(timeSeries.Type(), EMetricType::GAUGE);
    EXPECT_EQ(timeSeries.Columns(), NTs::TDoublePoint::SimpleColumns);
    EXPECT_EQ(timeSeries.PointCount(), ui32(0));

    auto it = timeSeries.Iterator();
    NTs::TVariantPoint point;
    EXPECT_FALSE(it->Next(&point));
}
