#pragma once

#include <solomon/libs/cpp/ts_codec/points.h>

namespace NSolomon::NDataProxy {

inline void FillCommon(TStringBuf time, TDuration step, ui64 count, NTs::TPointCommon* point) {
    point->Time = TInstant::ParseIso8601(time);
    if (step) {
        point->Step = step;
    }
    if (count) {
        point->Merge = true;
        point->Count = count;
    }
}

inline NTs::TDoublePoint DoublePoint(TStringBuf time, double value, TDuration step = TDuration::Zero(), ui64 count = 0) {
    NTs::TDoublePoint point;
    FillCommon(time, step, count, &point);
    point.Num = value;
    return point;
}

inline NTs::TDoublePoint DoublePoint(TStringBuf time, double num, ui64 denom, TDuration step = TDuration::Zero(), ui64 count = 0) {
    NTs::TDoublePoint point;
    FillCommon(time, step, count, &point);
    point.Num = num;
    point.Denom = denom;
    return point;
}

inline NTs::TLongPoint LongPoint(TStringBuf time, i64 value, TDuration step = TDuration::Zero(), ui64 count = 0) {
    NTs::TLongPoint point;
    FillCommon(time, step, count, &point);
    point.Value = value;
    return point;
}

inline NTs::TSummaryDoublePoint SummaryDoublePoint(TStringBuf time, NTs::NValue::TSummaryDouble summary, TDuration step = TDuration::Zero(), ui64 count = 0) {
    NTs::TSummaryDoublePoint point;
    FillCommon(time, step, count, &point);
    static_cast<NTs::NValue::TSummaryDouble&>(point) = summary;
    return point;
}

inline NTs::TSummaryIntPoint SummaryIntPoint(TStringBuf time, NTs::NValue::TSummaryInt summary, TDuration step = TDuration::Zero(), ui64 count = 0) {
    NTs::TSummaryIntPoint point;
    FillCommon(time, step, count, &point);
    static_cast<NTs::NValue::TSummaryInt&>(point) = summary;
    return point;
}

} // namespace NSolomon::NDataProxy
