#include <solomon/services/dataproxy/lib/timeseries/type_to_columns.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NDataProxy;

using NMonitoring::EMetricType;
using NTs::TColumnSet;
using NTs::EColumn;

void CheckValidCombinations(EMetricType type, EColumn valueColumn) {
    EXPECT_TRUE(IsValidTypeForColumns(type, TColumnSet{EColumn::TS, valueColumn}));
    EXPECT_TRUE(IsValidTypeForColumns(type, TColumnSet{EColumn::TS, valueColumn, EColumn::COUNT }));
    EXPECT_TRUE(IsValidTypeForColumns(type, TColumnSet{EColumn::TS, valueColumn, EColumn::COUNT, EColumn::MERGE}));
    EXPECT_TRUE(IsValidTypeForColumns(type, TColumnSet{EColumn::TS, valueColumn, EColumn::COUNT, EColumn::MERGE, EColumn::STEP}));
}

void CheckInvalidCombinations(EMetricType type, EColumn valueColumn) {
    EXPECT_FALSE(IsValidTypeForColumns(type, TColumnSet{EColumn::TS, valueColumn}));
    EXPECT_FALSE(IsValidTypeForColumns(type, TColumnSet{EColumn::TS, valueColumn, EColumn::COUNT }));
    EXPECT_FALSE(IsValidTypeForColumns(type, TColumnSet{EColumn::TS, valueColumn, EColumn::COUNT, EColumn::MERGE}));
    EXPECT_FALSE(IsValidTypeForColumns(type, TColumnSet{EColumn::TS, valueColumn, EColumn::COUNT, EColumn::MERGE, EColumn::STEP}));
}

TEST(TTypeToColumnsTest, ValidCombinations) {
    CheckValidCombinations(EMetricType::GAUGE, EColumn::VALUE);
    CheckValidCombinations(EMetricType::IGAUGE, EColumn::LONG_VALUE);
    CheckValidCombinations(EMetricType::COUNTER, EColumn::LONG_VALUE);
    CheckValidCombinations(EMetricType::RATE, EColumn::LONG_VALUE);
    CheckValidCombinations(EMetricType::HIST, EColumn::HISTOGRAM);
    CheckValidCombinations(EMetricType::HIST_RATE, EColumn::HISTOGRAM);
    CheckValidCombinations(EMetricType::DSUMMARY, EColumn::DSUMMARY);
    CheckValidCombinations(EMetricType::LOGHIST, EColumn::LOG_HISTOGRAM);
}

TEST(TTypeToColumnsTest, InValidCombinations) {
    CheckInvalidCombinations(EMetricType::GAUGE, EColumn::LONG_VALUE);
    CheckInvalidCombinations(EMetricType::IGAUGE, EColumn::VALUE);
    CheckInvalidCombinations(EMetricType::COUNTER, EColumn::DSUMMARY);
    CheckInvalidCombinations(EMetricType::RATE, EColumn::HISTOGRAM);
    CheckInvalidCombinations(EMetricType::HIST, EColumn::LOG_HISTOGRAM);
    CheckInvalidCombinations(EMetricType::HIST_RATE, EColumn::LONG_VALUE);
    CheckInvalidCombinations(EMetricType::DSUMMARY, EColumn::VALUE);
    CheckInvalidCombinations(EMetricType::LOGHIST, EColumn::HISTOGRAM);
}
