#include "ts_cache.h"

#include <solomon/services/dataproxy/config/cache_config.pb.h>

#include <solomon/libs/cpp/actors/config/log_component.pb.h>
#include <solomon/libs/cpp/actors/events/common.h>

#include <library/cpp/actors/core/actor_bootstrapped.h>
#include <library/cpp/actors/core/log.h>

namespace NSolomon::NDataProxy {
namespace  {

using namespace NActors;

class TTsCacheActor: public TActorBootstrapped<TTsCacheActor> {
public:
    explicit TTsCacheActor(const TCacheConfig& config) {
        Y_UNUSED(config);
    }

    void Bootstrap(const TActorContext& /*ctx*/) {
        Become(&TTsCacheActor::StateFunc);
    }

    void StateFunc(TAutoPtr<IEventHandle>& ev, const TActorContext& ctx) {
        switch (ev->GetTypeRewrite()) {
            HFunc(TCommonEvents::TAsyncPoison, OnPoison)
            // TODO: add rest events
        }
    }

    void OnPoison(const TCommonEvents::TAsyncPoison::TPtr& ev, const TActorContext& ctx) {
        LOG_DEBUG(ctx, ELogComponent::TsCache, "OnPoison");
        PassAway();
        ev->Get()->Done();
    }

private:
};

} // namespace

std::unique_ptr<NActors::IActor> CreateTsCache(const TCacheConfig& config) {
    return std::make_unique<TTsCacheActor>(config);
}

} // namespace NSolomon::NDataProxy
