package ru.yandex.solomon.dumper;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;

import com.google.protobuf.TextFormat;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.config.protobuf.dumper.TDumperConfig;
import ru.yandex.solomon.main.SpringContexts;

/**
 * @author Sergey Polovko
 */
@RunWith(Parameterized.class)
public class DumperMainContextTest {

    @Rule
    public Timeout timeout = Timeout.builder()
            .withLookingForStuckThread(true)
            .withTimeout(1, TimeUnit.MINUTES)
            .build();

    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters(name = "{0}")
    public static String[] configs() {
        return new String[]{
                "configs/testing/dumper.conf",
                "configs/prestable/dumper.conf",
                "configs/production/dumper.conf",
        };
    }

    @Test
    public void testConfiguration() throws IOException {
        Path configPath = Path.of(configFile);
        if (!Files.exists(configPath)) {
            Assert.fail("cannot find file " + configFile + ", CWD: " + Path.of(".").toAbsolutePath().normalize());
        }

        String configContent = Files.readString(configPath)
                .replace("{{CLUSTER}}", "sts1")
                .replace("{{DC}}", "myt");

        TDumperConfig config = parseConfig(configContent);
        Assert.assertNotEquals(TDumperConfig.getDefaultInstance(), config);

        try (var ctx = SpringContexts.createSimple(DumperMainContext.class, config)) {
            Assert.assertEquals(config, ctx.getBean(TDumperConfig.class));
        }
    }

    private TDumperConfig parseConfig(String configContent) throws TextFormat.ParseException {
        var builder = TDumperConfig.newBuilder();
        TextFormat.merge(configContent, builder);
        return builder.build();
    }
}
