package ru.yandex.solomon.dumper;

import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;

import javax.annotation.Nonnull;

/**
 * @author Vladimir Gordiychuk
 */
public class DumperShardId {
    public static final int SHARD_COUNT = 4 << 10;
    public static final int FIRST_SHARD_ID = 1;
    public static final int LAST_SHARD_ID = FIRST_SHARD_ID + SHARD_COUNT - 1;


    public static IntStream idStream() {
        return IntStream.rangeClosed(FIRST_SHARD_ID, LAST_SHARD_ID);
    }

    public static int random() {
        return FIRST_SHARD_ID + ThreadLocalRandom.current().nextInt(SHARD_COUNT);
    }

    @Nonnull
    public static String toString(int id) {
        return Integer.toString(id);
    }
}
