package ru.yandex.solomon.dumper;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public class DumperShardMetricSupplier implements MetricSupplier {
    private final DumperLocalShards shards;
    private volatile int metricsCount;

    public DumperShardMetricSupplier(DumperLocalShards shards) {
        this.shards = shards;
    }

    @Override
    public int estimateCount() {
        return metricsCount;
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        var noHostCommonLabels = commonLabels.add("host", "");
        var instant = new DumperShardMetricsInstant();
        int metricsCount = instant.estimateCount();
        for (DumperShard shard : shards) {
            var metrics = shard.metrics();
            metricsCount += metrics.estimateCount();
            metrics.append(tsMillis, noHostCommonLabels, consumer);
            instant.combine(metrics);
        }
        instant.append(tsMillis, commonLabels, consumer);
        this.metricsCount = metricsCount;
    }
}
