package ru.yandex.solomon.dumper;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.counters.AsyncMetrics;

/**
 * @author Vladimir Gordiychuk
 */
public class DumperShardMetricsAggregated implements MetricSupplier {
    private MetricRegistry registry;
    public final Rate readBytes;
    public final Histogram readBytesSize;
    public final Rate readFiles;
    public final Rate preparedTxn;
    public final Rate committedTxn;
    public final AsyncMetrics txRead;
    public final AsyncMetrics txWrite;
    public final AsyncMetrics txParse;
    public final AsyncMetrics txCommit;
    public final Rate processingErrors;
    public final GaugeInt64 processCount;
    public final SolomonShardProcessMetrics processMetrics;

    public final Rate kvErrors;

    public DumperShardMetricsAggregated() {
        this.registry = new MetricRegistry();
        this.readBytes = registry.rate("dumper.host.txn.read.bytes");
        this.readBytesSize = registry.histogramRate("dumper.host.txn.read.bytesSize", Histograms.exponential(25, 2, 32));
        this.readFiles = registry.rate("dumper.host.txn.read.files");
        this.preparedTxn = registry.rate("dumper.host.txn.prepared");
        this.committedTxn = registry.rate("dumper.host.txn.committed");
        this.kvErrors = registry.rate("dumper.host.kv.errors");
        this.txRead = new AsyncMetrics(registry, "dumper.host.txn.read");
        this.txWrite = new AsyncMetrics(registry, "dumper.host.txn.write");
        this.txParse = new AsyncMetrics(registry, "dumper.host.txn.parse");
        this.txCommit = new AsyncMetrics(registry, "dumper.host.txn.commit");
        this.processingErrors = registry.rate("dumper.host.processing.errors");
        this.processCount = registry.gaugeInt64("dumper.host.process.count");
        this.processMetrics = new SolomonShardProcessMetrics(registry);
    }

    @Override
    public int estimateCount() {
        return registry.estimateCount();
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        registry.append(tsMillis, commonLabels, consumer);
    }
}
